/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    private static final Pattern BINARY_FILES_DIFFER_PATTERN = Pattern.compile("^Binary files (a\\/)?(.*) and (b\\/)?(.*) differ$");
    private static final Pattern RENAME_PATTERN = Pattern.compile("^rename (from|to) (.*)$");
    private static final Pattern PLUS_PATTERN = Pattern.compile("^\\+\\+\\+ (b\\/)?(.*)$");
    private static final Pattern MINUS_PATTERN = Pattern.compile("^--- (a\\/)?(.*)$");
    private static final Pattern DELETED_FILE_MODE_PATTERN = Pattern.compile("^deleted file mode .*$");
    private static final Pattern OLD_MODE_PATTERN = Pattern.compile("^old mode (.*)$");
    private static final Pattern NEW_MODE_PATTERN = Pattern.compile("^new mode (.*)$");
    private static final Pattern NEW_FILE_MODE_PATTERN = Pattern.compile("^new file mode .*$");
    private static final Pattern DIFF_GIT_PATTERN = Pattern.compile("^diff --git (a\\/)+(.*) (b\\/)+(.*)$");
    private static final String DEV_NULL = "/dev/null";
    private boolean isBinary;
    private String oldName;
    private String newName;
    private GitCommit commit;

    private Diff(GitCommit commit, boolean binary, String startname, String endname) {
        this.commit = commit;
        this.isBinary = binary;
        this.oldName = startname;
        this.newName = endname;
    }

    private static List<Diff> parse(GitCommit commit, Reader content) throws IOException {
        long start = System.currentTimeMillis();
        boolean header = false;
        boolean binary = false;
        boolean readPrologue = false;
        String startname = "";
        String endname = "";
        ArrayList<Diff> files = new ArrayList<Diff>();
        BufferedReader buffReader = new BufferedReader(content);
        try {
            String l = null;
            while ((l = buffReader.readLine()) != null) {
                Matcher m;
                if (l.length() == 0) continue;
                char firstChar = l.charAt(0);
                if (firstChar == 'd' && l.charAt(1) == 'i') {
                    header = true;
                    if (!readPrologue) {
                        readPrologue = true;
                    } else {
                        files.add(new Diff(commit, binary, startname, endname));
                    }
                    startname = "";
                    endname = "";
                    binary = false;
                    m = DIFF_GIT_PATTERN.matcher(l);
                    if (!m.find()) continue;
                    startname = m.group(2);
                    endname = m.group(4);
                    continue;
                }
                if (!header) continue;
                switch (firstChar) {
                    case 'n': {
                        m = NEW_FILE_MODE_PATTERN.matcher(l);
                        if (m.find()) {
                            startname = DEV_NULL;
                        }
                        m = NEW_MODE_PATTERN.matcher(l);
                        break;
                    }
                    case 'o': {
                        m = OLD_MODE_PATTERN.matcher(l);
                        break;
                    }
                    case 'd': {
                        m = DELETED_FILE_MODE_PATTERN.matcher(l);
                        if (!m.find()) break;
                        endname = DEV_NULL;
                        break;
                    }
                    case '-': {
                        m = MINUS_PATTERN.matcher(l);
                        if (!m.find()) break;
                        startname = m.group(2);
                        break;
                    }
                    case '+': {
                        m = PLUS_PATTERN.matcher(l);
                        if (!m.find()) break;
                        endname = m.group(2);
                        break;
                    }
                    case 'r': {
                        m = RENAME_PATTERN.matcher(l);
                        if (!m.find()) break;
                        if (m.group(1).equals("from")) {
                            startname = m.group(2);
                            break;
                        }
                        endname = m.group(2);
                        break;
                    }
                    case 'B': {
                        binary = true;
                        m = BINARY_FILES_DIFFER_PATTERN.matcher(l);
                        if (!m.find()) break;
                        startname = m.group(2);
                        endname = m.group(4);
                        break;
                    }
                    case '@': {
                        header = false;
                        break;
                    }
                }
            }
            files.add(new Diff(commit, binary, startname, endname));
            Diff.log(MessageFormat.format("Took {0}ms to parse out {1} diffs", System.currentTimeMillis() - start, files.size()));
        }
        finally {
            buffReader.close();
        }
        return files;
    }

    private static void log(String string) {
        if (GitPlugin.getDefault() != null) {
            IdeLog.logInfo((Plugin)GitPlugin.getDefault(), (String)string);
        } else {
            System.out.println(string);
        }
    }

    public boolean fileCreated() {
        return this.oldName.equals(DEV_NULL);
    }

    public boolean fileDeleted() {
        return this.newName.equals(DEV_NULL);
    }

    public String fileName() {
        if (this.newName.equals(DEV_NULL)) {
            return this.oldName;
        }
        return this.newName;
    }

    public GitCommit commit() {
        return this.commit;
    }

    public String oldName() {
        return this.oldName;
    }

    public String newName() {
        return this.newName;
    }

    static List<Diff> create(GitCommit gitCommit) {
        try {
            IStatus result = gitCommit.repository().executeWithPromptHandling(GitRepository.ReadWrite.READ, "show", "--pretty=raw", "-M", "--no-color", gitCommit.sha());
            return Diff.parse(gitCommit, new StringReader(result.getMessage()));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public boolean renamed() {
        return !this.fileCreated() && !this.fileDeleted() && !this.newName.equals(this.oldName);
    }
}

